class HUD_MA2 extends HUD_MH;

simulated function PostRender( canvas Canvas )
{
	HUDSetup(canvas);
	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
		return;

	if ( DrawTime > 0 || LogoColor.R > 0)
		{
		RenderLogo(Canvas);
		DrawTime--;
		if ( DrawTime < 0 )
			{
			LogoColor.R -= 1;
			}
		}

	Canvas.bNoSmooth = False;
	ShowRaderBase(Canvas);
	ShowRadar(Canvas);
	Canvas.bNoSmooth = True;

	DrawMonsterName(Canvas);
	DrawFragCount(Canvas);
	DrawStatus(Canvas);
	DrawAmmo(Canvas);
	DrawWeapons(Canvas);
	DrawGameSynopsis(Canvas);

	super.PostRender(Canvas);
}

simulated function DrawWeapons(Canvas Canvas)
{
//Used to draw monsters:

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX - 128, Canvas.ClipY - 128);
	Canvas.DrawTile(Texture'Icon_Monster', 128, 128, 0, 0, 128, 128);

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = RedColor;
	DrawBigNum(Canvas, GRI_MA2(PlayerPawn(Owner).GameReplicationInfo).Monsters, Canvas.ClipX - 84, Canvas.ClipY - 40, 0.75);

}

simulated function DrawAmmo(Canvas Canvas)
{
//Used to draw players:

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX - 128, Canvas.ClipY - 256);
	Canvas.DrawTile(Texture'Icon_Player', 128, 128, 0, 0, 128, 128);

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = GreenColor;
	DrawBigNum(Canvas, GRI_MA2(PlayerPawn(Owner).GameReplicationInfo).Players, Canvas.ClipX - 84, Canvas.ClipY - 168, 0.75);
}

simulated function DrawFragCount(Canvas Canvas)
{
local float XL, YL, YL2;
local GRI_MA2 GRI;

	GRI = GRI_MA2(PlayerPawn(Owner).GameReplicationInfo);

	if ( PawnOwner.PlayerReplicationInfo == None )
		return;

	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.StrLen("0123456789", XL, YL);
	Canvas.SetPos(0, Canvas.ClipY - YL);
	Canvas.DrawText("Score:"@int(PawnOwner.PlayerReplicationInfo.Score));
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("0123456789", XL, YL2);
	Canvas.SetPos(0, Canvas.ClipY - YL * 2);
	if ( GRI.Wave > 10)
		Canvas.DrawText("Round: 10/10");
	else
		Canvas.DrawText("Round:"$GRI_MA2(PlayerPawn(Owner).GameReplicationInfo).Wave$"/10");
}

defaultproperties
{
}

